import os
import sys
import importlib
import argparse
import csv
import numpy as np
import time
import pickle

import pyscipopt as scip

from pyscipopt import Model, quicksum
import pandas as pd

if __name__ == '__main__':
    instances = []
    time_limit = 1000

    instances = os.listdir("/home/ubuntu/yuanhao/Learn-LNS-policy-main/LNS_graph_update/miplib2017")
    branching_policies = []

    print("running SCIP...")

    instance_list = []
    transfer_integer_count_list = []
    transfer_integer_unbounded_list = []
    transfer_single_unbounded_list = []
    transfer_double_unbounded_list = []

    original_integer_count_list = []
    original_integer_unbounded_list = []
    original_single_unbounded_list = []
    original_double_unbounded_list = []

    presolve_time_list = []

    time_limit = 1000

    for instance in instances:
        print("{}...".format(instance))

        path = "/home/ubuntu/yuanhao/Learn-LNS-policy-main/LNS_graph_update/miplib2017/" + instance

        m = scip.Model()
        m.readProblem("{}".format(path))

        m.setRealParam('limits/time', time_limit)

        m.presolve()

        v = m.getVars(transformed=True)[0]

        unbounded_threshold = 1e10

        transfer_integer_count = 0
        transfer_integer_unbounded = 0
        transfer_single_unbounded = 0
        transfer_double_unbounded = 0
        for variable in m.getVars(transformed=True):
            if variable.vtype() == 'INTEGER':
                transfer_integer_count += 1
                if variable.getLbGlobal() < -unbounded_threshold or variable.getUbGlobal() > unbounded_threshold:
                    print(variable.getLbGlobal(), variable.getUbGlobal())
                    transfer_integer_unbounded += 1
                    if variable.getLbGlobal() < -unbounded_threshold and variable.getUbGlobal() > unbounded_threshold:
                        transfer_double_unbounded += 1
                    else:
                        transfer_single_unbounded += 1

        
        print("------------------------Original Variables---------------------------------")
        original_integer_count = 0
        original_integer_unbounded = 0
        original_single_unbounded = 0
        original_double_unbounded = 0
        for variable in m.getVars():
            if variable.vtype() == 'INTEGER':
                original_integer_count += 1
                if variable.getLbOriginal() < -unbounded_threshold or variable.getUbOriginal() > unbounded_threshold:
                    print(variable.getLbOriginal(), variable.getUbOriginal())
                    original_integer_unbounded += 1
                    if variable.getLbOriginal() < -unbounded_threshold and variable.getUbOriginal() > unbounded_threshold:
                        original_double_unbounded += 1
                    else:
                        original_single_unbounded += 1

        print(transfer_integer_count, transfer_integer_unbounded)
        print(original_integer_count, original_integer_unbounded)

        instance_list.append(instance)
        original_integer_count_list.append(original_integer_count)
        original_integer_unbounded_list.append(original_integer_unbounded)

        transfer_integer_count_list.append(transfer_integer_count)
        transfer_integer_unbounded_list.append(transfer_integer_unbounded)

        presolve_time_list.append(m.)
    
    df = pd.DataFrame()

    df['Instance'] = instance_list
    df['Original_integer'] = original_integer_count_list
    df['Original_integer_unbounded'] = original_integer_unbounded_list

    df['Transform_integer'] = transfer_integer_count_list
    df['Transform_integer_unbounded'] = transfer_integer_unbounded_list

    df.to_csv("MIPLIB2017_integer.csv", index=False)